'use strict';

angular.module('genisis').controller('studyApprovalCtrl', ['$scope',
  'studyApproval', '$location',
  function ($scope, $studies, $location) {

    $scope.studies = null;
    $scope.orderBy = '';

    //load the studies
    $studies.load().then(function (userStudies) {
      $scope.studies = userStudies;
    });

    /**
     * Clicking the button to go to the create study page
     **/
    $scope.createStudyApproval = function () {
      $location.path('/createStudy');
    };

    /**
     * Trying to edit a study approval
     * @param int study approval id
     **/
    $scope.editStudy = function (id) {
      $location.path('/studyApprovals/' + id);
    };
  }
]);